SWEP.AdminSpawnable = true
SWEP.ViewModelFOV = 90
SWEP.ViewModel = "models/weapons/v_shotgunk.mdl"
SWEP.WorldModel = "models/w_shotgunk.mdl"
SWEP.AutoSwitchTo = true
SWEP.Slot = 3
SWEP.HoldType = "crossbow"
SWEP.PrintName = "Shotgun"
SWEP.Spawnable = true
SWEP.AutoSwitchFrom = true
SWEP.FiresUnderwater = true
SWEP.Weight = 5
	SWEP.DrawCrosshair		= false
SWEP.Category = "Kingpin"
SWEP.SlotPos = 2
SWEP.DrawAmmo = true
SWEP.ReloadSound = ("v_shotgunk/shotgload.wav")
SWEP.Base = "kingpin_base"
if ( CLIENT ) then
SWEP.WepSelectIcon		= surface.GetTextureID( "vgui/h_shotgun" )
	
	killicon.Add( "kingpin_shotgun", "vgui/ah_shotgun", Color( 255, 80, 0, 255 ) )
	end
SWEP.Primary.Sound = ("v_shotgunk/shotgun.wav")
SWEP.Primary.Reload = ("v_shotgunk/shotgload.wav")
SWEP.Primary.Damage = 10
SWEP.Primary.TakeAmmo = 1
SWEP.Primary.ClipSize = 8
SWEP.Primary.Ammo = "buckshot"
SWEP.Primary.DefaultClip = 8
SWEP.Primary.Spread = 1
SWEP.Primary.NumberofShots = 12
SWEP.Primary.Automatic = true
SWEP.Primary.Recoil = 1
SWEP.Primary.Delay = 1
SWEP.Primary.Force = 1
SWEP.BobScale	= 0.3
SWEP.SwayScale	= 0.1



function SWEP:Initialize()
        self:SetWeaponHoldType( self.HoldType )
end


function SWEP:Deploy()
	self.Weapon:SetNextPrimaryFire(CurTime() +.6)
	self.Weapon:SendWeaponAnim(ACT_VM_DRAW)
		   	self.Weapon:SetNetworkedBool( "reloading", false)

	return true
end

function SWEP:SecondaryAttack()	
end
function SWEP:Holster()
	self.Owner:SetNWBool("kpplysounds", false)
	return true
	end
//SWEP:PrimaryFire()\\
function SWEP:PrimaryAttack()	
if not IsValid(self.Owner) or self.Owner:Health() < 0 or !self:CanPrimaryAttack() then return end
	local bullet = {}
		bullet.Num = self.Primary.NumberofShots
		bullet.Src = self.Owner:GetShootPos()
		bullet.Dir = self.Owner:GetAimVector()
		bullet.Spread = Vector( self.Primary.Spread * 0.1 , self.Primary.Spread * 0.1, 0)
		bullet.Tracer = 0
		bullet.Force = self.Primary.Force
		bullet.Damage = self.Primary.Damage
		bullet.AmmoType = self.Primary.Ammo
	local rnda = self.Primary.Recoil * -1
	local rndb = self.Primary.Recoil * math.random(-1, 1)
	self:ShootEffects()
	self.Owner:FireBullets( bullet )
			self:Muzzleflash()
	self.Weapon:EmitSound(Sound(self.Primary.Sound))
	self.Owner:ViewPunch( Angle( rnda,rndb,rnda ) )
	self:TakePrimaryAmmo(self.Primary.TakeAmmo)
	self.Weapon:SetNextPrimaryFire( CurTime() + self.Primary.Delay )
	self.Weapon:SetNextSecondaryFire( CurTime() + self.Primary.Delay )
end
//SWEP:PrimaryFire()\\

function SWEP:SecondaryAttack()
end
function SWEP:DryFire()
	self.Weapon:EmitSound("weapons/v_pipebar/noammo.wav")
end
function SWEP:Muzzleflash()
	local pos = self.Owner:GetShootPos()
	local ang = self.Owner:GetAimVector():Angle()
	pos = pos +ang:Forward() *30 +ang:Right() *12 +ang:Up() *1
	local effectdata = EffectData()
	effectdata:SetStart( pos )
	effectdata:SetOrigin( pos )
	util.Effect("kp_muzz", effectdata)
end


/*---------------------------------------------------------
Reload
---------------------------------------------------------*/
function SWEP:Reload()

	
	if (self.Weapon:GetNWBool("reloading", false)) or ShotgunReloading then return end

	if (self.Weapon:Clip1() < self.Primary.ClipSize and self.Owner:GetAmmoCount(self.Primary.Ammo) > 0) then
			ShotgunReloading = true
			self.Weapon:SetNextPrimaryFire(CurTime() + 0.5)
			self.Weapon:SetNextSecondaryFire(CurTime() + 0.5)
			self.Weapon:SendWeaponAnim(ACT_SHOTGUN_RELOAD_START)
		timer.Simple(0.3, function()
			ShotgunReloading = false
			self.Weapon:SetNetworkedBool("reloading", true)
			self.Weapon:SetVar("reloadtimer", CurTime() + 0.8)
			self.Weapon:SetNextPrimaryFire(CurTime() + 0.5)
			self.Weapon:SetNextSecondaryFire(CurTime() + 0.5)
		end)
	end
end

function SWEP:Think()
self:Stuff()
	if self.Weapon:Clip1() > self.Primary.ClipSize then
		self.Weapon:SetClip1(self.Primary.ClipSize)
	end

	if self.Weapon:GetNetworkedBool( "reloading") == true then
	
		if self.Weapon:GetNetworkedInt( "reloadtimer") < CurTime() then
			if self.unavailable then return end

			if ( self.Weapon:Clip1() >= self.Primary.ClipSize || self.Owner:GetAmmoCount( self.Primary.Ammo ) <= 0 ) then
				self.Weapon:SetNextPrimaryFire(CurTime() + 0.6)
				self.Weapon:SetNextSecondaryFire(CurTime() + 0.5)
				self.Weapon:SetNetworkedBool( "reloading", false)
				self.Weapon:SendWeaponAnim(ACT_SHOTGUN_RELOAD_FINISH)
			else
			
			self.Weapon:SetNetworkedInt( "reloadtimer", CurTime() + 0.8 )
			self.Weapon:SendWeaponAnim( ACT_VM_RELOAD )
			self:EmitSound("v_shotgunk/shotgload.wav")
			self.Owner:RemoveAmmo( 1, self.Primary.Ammo, false )
			self.Weapon:SetClip1(  self.Weapon:Clip1() + 1 )
			self.Weapon:SetNextPrimaryFire(CurTime() + 0.8)
			self.Weapon:SetNextSecondaryFire(CurTime() + 0.8)

				if ( self.Weapon:Clip1() >= self.Primary.ClipSize || self.Owner:GetAmmoCount( self.Primary.Ammo ) <= 0) then
					self.Weapon:SetNextPrimaryFire(CurTime() + .8)
					self.Weapon:SetNextSecondaryFire(CurTime() + .8)
				else
					self.Weapon:SetNextPrimaryFire(CurTime() + 0.8)
					self.Weapon:SetNextSecondaryFire(CurTime() + 0.8)
				end
			end
		end
	end


	if self.Owner:KeyPressed(IN_ATTACK) and (self.Weapon:GetNWBool("reloading", true)) then
		self.Weapon:SetNextPrimaryFire(CurTime() + 0.5)
		self.Weapon:SetNextPrimaryFire(CurTime() + 0.5)
		self.Weapon:SetNetworkedBool( "reloading", false)
		self.Weapon:SendWeaponAnim(ACT_SHOTGUN_RELOAD_FINISH)
	end
end